//Capital Budgeting
//Net Present Value - Project Selection
//OS:Windows 10
//Scilab 5.5.2

clear;
clc;
close;

//Given
projectA_investment = 60000     //in rupees
projectB_investment = 80000     //in rupees
estimatedlife_A = 7       //in years
estimatedlife_B = 7       //in years
scrapvalue_A = 9000    //in rupees
scrapvalue_B = 11000    //in rupees
pv_10 = [0.909,0.826,0.751,0.683,0.621]       //discount rate of 10%
projectA_CF = [20000,19000,18000,12500,9000]
projectB_CF = [68000,42000,15000,14000,11000]
projectA_CF($+1) = scrapvalue_A  //last value is always scrap value
projectB_CF($+1) = scrapvalue_B  //last value is always scrap value
pvcf_A = []       //present value
pvcf_B = []       //present value

//Solution
//Project A Present Value
for i=1:5
    pvcf_A($+1) = pv_10(i) * projectA_CF(i)
end
total_pvcf = sum(pvcf_A)
NPV_A = total_pvcf - projectA_investment

//Project B Present Value
for i=1:5
    pvcf_B($+1) = pv_10(i) * projectB_CF(i)
end
total_pvcf = sum(pvcf_B)
NPV_B = total_pvcf - projectB_investment

//Result
mprintf("\n  Particulars\t    Project A\t  Project B")
mprintf("\n\n  Initial Investment   %d        %d",projectA_investment,projectB_investment)
mprintf("\n  (in rupees)")
mprintf("\n\n  Estimated life")
mprintf("         %d\t      %d",estimatedlife_A,estimatedlife_B)
mprintf("\n  (in years)")
mprintf("\n\n  Scrap value")
mprintf("          %d\t    %d",scrapvalue_A,scrapvalue_B)
mprintf("\n  (in rupees)\n")
mprintf("\n  Year\tProject A CF\tProject B CF")
for i=1:5
    mprintf("\n   %d\t   %d     \t   %d",i,projectA_CF(i),projectB_CF(i))
end
mprintf("\n\n  Project A")
mprintf("\n  Year\tCash inflows(CF)     PV@10percent\tPVCF")
for i=1:5
    mprintf("\n   %d\t   %d   \t        %.3f\t        %d",i,projectA_CF(i),pv_10(i),pvcf_A(i))
end
mprintf("\n\n  Project B")
mprintf("\n  Year\tCash inflows(CF)     PV@10percent\tPVCF")
for i=1:5
    mprintf("\n   %d\t   %d   \t        %.3f\t        %d",i,projectB_CF(i),pv_10(i),pvcf_B(i))
end
mprintf("\n\n   NPV for Project A: %.2f",NPV_A)
mprintf("\n   NPV for Project B: %d",NPV_B)

if NPV_A > NPV_B then
    mprintf("\n   Project A is accepted as its NPV is higher")
else
    mprintf("\n   Project B is accepted as its NPV is higher")
end

//Output
//   Particulars	    Project A	  Project B
// 
//   Initial Investment   60000        80000
//   (in rupees)
// 
//   Estimated life         7	      7
//   (in years)
// 
//   Scrap value          9000	    11000
//   (in rupees)
// 
//   Year	Project A CF	Project B CF
//    1	   20000     	   68000
//    2	   19000     	   42000
//    3	   18000     	   15000
//    4	   12500     	   14000
//    5	   9000     	   11000
// 
//   Project A
//   Year	Cash inflows(CF)     PV@10percent	PVCF
//    1	   20000   	        0.909	        18180
//    2	   19000   	        0.826	        15694
//    3	   18000   	        0.751	        13518
//    4	   12500   	        0.683	        8537
//    5	   9000   	        0.621	        5589
// 
//   Project B
//   Year	Cash inflows(CF)     PV@10percent	PVCF
//    1	   68000   	        0.909	        61812
//    2	   42000   	        0.826	        34692
//    3	   15000   	        0.751	        11265
//    4	   14000   	        0.683	        9562
//    5	   11000   	        0.621	        6831
// 
//    NPV for Project A: 1518.50
//    NPV for Project B: 44162
//    Project B is accepted as its NPV is higher
